# While 循环
你已经解锁了 `while` 循环和 `True`、`False` 这两个值。`while` 循环会在条件为 `True` 的情况下一直执行循环体。

`while 条件:
	#循环体`

不用担心创建无限循环。游戏对执行的延迟设计会防止程序卡死。

## 面向初学者
也许你已经试过连续写好几个 `harvest()` 调用：

`harvest()
harvest()
harvest()`

这让你可以在一次程序运行中收获好几次。
然而，如果能收获超过三次就更好了，而多次重复同样的代码也并非好的做法。
解决方法是循环。
循环让你能多次运行同样的代码。

`while` 循环接受一个条件，条件为逻辑值，只能是两种状态之一：`True` 或 `False`。
这样的值被称为布尔值。

然后循环就会执行循环内的代码，直到条件变为 `False`。
`while` 循环的形式如下：

`while 条件:
	#循环体
	#循环体
	#...`
	
你必须把“条件”替换成一个布尔值，把`#循环体`替换成任何你想在循环中做的事情。

有两个可用的常量布尔值。常量是在程序运行期间永远不会改变的值。

要创建一个始终为 `True` 的常量布尔值，只需写 `True` 即可。写 `False` 则代表一个始终为 `False` 的常量布尔值。
所以你可以写


`while False:
	do_a_flip()`

或者

`while True:
	do_a_flip()`

第一个永远不会翻转，第二个会永远翻转（一个无限循环）。

创建无限循环通常不是个好主意，因为会导致程序卡死，但在这款游戏中，循环的每次迭代之间都有延迟，所以它只会让无人机一直翻转，直到你再次按下执行按钮手动让它停下。

注意冒号后面的行是如何缩进的。这样的缩进是用来分隔代码块的。
按 Tab 键即可添加缩进，按 Shift + Tab（或 Backspace）即可移除缩进。

循环会重复冒号后所有缩进的语句。
缩进代码块之后的语句会在循环结束后执行。
